use master
GO

set nocount on 

--set to 0 to skip updating the A4Survey_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @ClientPayload01 nvarchar(max) = N'
-- DEV-90568  66543
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[A4S_sp_RenameResponsesVariables]'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE [dbo].[A4S_sp_RenameResponsesVariables]
'

declare @ClientPayload02 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_RenameResponsesVariables]
 @surveyId INT,
 @deployedVersion INT
AS
BEGIN
 DECLARE @RenamedVariables TABLE ( [VariableId] int, [NewName] nvarchar(255), [OldName] nvarchar(255) ) 
  
 INSERT INTO @RenamedVariables ([VariableId], [NewName], [OldName])
 SELECT v.[Id], v.[Name], v2.[Name] as ''OldName''
   FROM [SAT].[Variables] v
   INNER JOIN [SAT].[BlockItems] bi ON v.QuestionId = bi.Id AND bi.[Version] = @deployedVersion
   INNER JOIN [SAT].[Blocks] b ON bi.BlockId = b.Id AND b.[Version] = @deployedVersion
   INNER JOIN [SAT].[QuestionnaireVersions] qv ON b.QuestionnaireId = qv.Id AND qv.[Version] = @deployedVersion
   INNER JOIN [SAT].Variables v2 ON v.[Id] = v2.[Id] 
   WHERE qv.Id = @surveyId and v.[Version] = @deployedVersion and v2.[Version] = @deployedVersion - 1 and v.[Name] <> v2.[Name]
   
 IF ((SELECT COUNT(*) FROM @RenamedVariables) > 0)
 BEGIN
  DECLARE renamedVariablesCursor CURSOR FOR SELECT [OldName], [NewName] FROM @RenamedVariables
  DECLARE @oldName NVARCHAR(255)
  DECLARE @newName NVARCHAR(255)
  
  DECLARE @schemaName nvarchar(40) = [dbo].GetProjectSchema(@surveyId);
  DECLARE @updateQuery NVARCHAR (150) = ''UPDATE TOP (10000) '' + @schemaName + ''.[Response] SET RpsQuestion = @newName WHERE [RpsQuestion] = @oldName''
  DECLARE @updateRespondentVariableDisplayOrderQuery NVARCHAR (150) = ''UPDATE TOP (10000) '' + @schemaName + ''.[RespondentVariableDisplayOrder] SET VariableName = @newName WHERE [VariableName] = @oldName''
  DECLARE @updateRespondentVariableRandomizationQuery NVARCHAR (150) = ''UPDATE TOP (10000) '' + @schemaName + ''.[RespondentVariableRandomization] SET VariableName = @newName WHERE [VariableName] = @oldName''

  DECLARE @countQuery NVARCHAR (150) = ''SELECT @questionCountOUT = COUNT([RpsQuestion]) FROM '' + @schemaName + ''.[Response] WHERE RpsQuestion = @oldName''
  DECLARE @questionCount INT
  
  OPEN renamedVariablesCursor;
  FETCH NEXT FROM renamedVariablesCursor INTO @oldName, @newName;
  WHILE @@FETCH_STATUS = 0 BEGIN
   EXEC sp_executesql @countQuery, N''@oldName nvarchar(255), @questionCountOUT int OUTPUT'',  @oldName=@oldName, @questionCountOUT=@questionCount OUTPUT 
   WHILE ( @questionCount > 0 )
   BEGIN
    BEGIN TRANSACTION
    EXEC sp_executesql @updateQuery, N''@oldName nvarchar(255), @newName nvarchar(255)'', @oldName=@oldName, @newName=@newName
    COMMIT

    BEGIN TRANSACTION
    EXEC sp_executesql @updateRespondentVariableDisplayOrderQuery, N''@oldName nvarchar(255), @newName nvarchar(255)'', @oldName=@oldName, @newName=@newName
    COMMIT

	 BEGIN TRANSACTION
    EXEC sp_executesql @updateRespondentVariableRandomizationQuery, N''@oldName nvarchar(255), @newName nvarchar(255)'', @oldName=@oldName, @newName=@newName
    COMMIT

    EXEC sp_executesql @countQuery, N''@oldName nvarchar(255), @questionCountOUT int OUTPUT'',  @oldName=@oldName, @questionCountOUT=@questionCount OUTPUT 
   END
   FETCH NEXT FROM renamedVariablesCursor INTO @oldName, @newName;
  END
  
  CLOSE renamedVariablesCursor
  DEALLOCATE renamedVariablesCursor  
 END
 
 SELECT * FROM @RenamedVariables
END
'

--declare @SurveyPayload01 nvarchar(max) = N'waitfor delay ''0:00:01'''

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)
create table #Survey (
	DBName nvarchar(128),
	SchemaName nvarchar(128),
	Processed tinyint default 0
)
create table #SurveyVerif (
	DBName nvarchar(128),
	SchemaName nvarchar(128)
)
create table #SurveysDone (
	DBName nvarchar(128) collate database_default,
	SchemaName nvarchar(128) collate database_default
)
declare @AllDone bit = 0, 
        @TotalClients int, 
		@TotalSurveys int, 
		@ClientCounter int, 
		@SurveyCounter int, 
		@ThisClient nvarchar(128), 
		@ThisSurvey nvarchar(128), 
		@ClientCursor cursor, 
		@SurveyCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalClients = 0, @TotalSurveys = 0, @ClientCounter = 0, @SurveyCounter = 0
	insert into #DB 
	select 'A4Survey_Client_' + cast(Id as nvarchar(16)), 0 from Acuity4.dbo.Client
	     
    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Survey_Client_Template', 0)

	select @TotalClients = count(*) 
	       from #DB
	
	set @ClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @ClientCursor
	fetch next from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @ClientCounter += 1
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #Survey select ''' + @ThisClient + ''', SchemaName, 0 from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName, 0 from #SurveysDone'
		exec @DBSQL @SQL
		select @StatusMessage = 'Updating client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ClientCounter / @TotalClients
		raiserror (@StatusMessage, 0, 1, @ThisClient, @ClientCounter, @TotalClients, @StatusPercent) with nowait
		
		print 'Client Payload 1'
		select @SQL = replace(replace(@ClientPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 2'
		select @SQL = replace(replace(@ClientPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'All Client Payload done for  client ' + @ThisClient + '!'

		update #DB set Processed = 1 where current of @ClientCursor
		fetch next from @ClientCursor into @ThisClient
	end


	close @ClientCursor
	deallocate @ClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Survey_Client_Template';
      SET @SQL = 'USE Acuity4;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
drop table #Survey
drop table #SurveyVerif
drop table #SurveysDone